/*
 * Decompiled with CFR 0.152.
 */
package jace.hardware.mockingboard;

import jace.hardware.mockingboard.Card;
import jace.hardware.mockingboard.EnvelopeGenerator;
import jace.hardware.mockingboard.NoiseGenerator;
import jace.hardware.mockingboard.TimedGenerator;

public class SoundGenerator
extends TimedGenerator {
    int amplitude;
    boolean useEnvGen;
    boolean active;
    boolean noiseActive;
    boolean inverted;

    public SoundGenerator(int _clock, int _sampleRate) {
        super(_clock, _sampleRate);
    }

    public double stepsPerCycle() {
        return 16.0;
    }

    public void step() {
        int stateChanges = this.updateCounter();
    }

    public void setAmplitude(int _amp) {
        this.amplitude = _amp & 0xF;
        this.useEnvGen = (_amp & 0x10) != 0;
    }

    public void setActive(boolean _active) {
        this.active = _active;
    }

    public void setNoiseActive(boolean _active) {
        this.noiseActive = _active;
    }

    public int step(NoiseGenerator noiseGen, EnvelopeGenerator envGen) {
        int vol;
        int stateChanges = this.updateCounter();
        if ((stateChanges & 1) > 0) {
            boolean bl = this.inverted = !this.inverted;
        }
        if (this.amplitude == 0 && !this.useEnvGen) {
            return 0;
        }
        if (!this.active && !this.noiseActive) {
            return 0;
        }
        boolean invert = false;
        int n = vol = this.useEnvGen ? envGen.getAmplitude() : this.amplitude;
        invert = this.active ? (this.noiseActive && noiseGen.isOn() ? false : this.inverted) : this.noiseActive && !noiseGen.isOn();
        return invert ? -Card.VolTable[vol] : Card.VolTable[vol];
    }

    public void reset() {
        super.reset();
        this.amplitude = 0;
        this.useEnvGen = false;
        this.active = false;
        this.noiseActive = false;
        this.inverted = false;
    }
}

